#include <stdio.h>
#include <stdlib.h>

#define SKUP_B 0
#define SKUP_N 1

double **A;
double *b, *c, *x, v;
int n, m;
int *NB;

void unesiPodatke() {
	int i, j;
	
	double jecamSvetlo, hmeljSvetlo, psenicaSvetlo, kvasacSvetlo;
	double jecamTamno, hmeljTamno, psenicaTamno, kvasacTamno;
	double jecamNefilt, hmeljNefilt, psenicaNefilt, kvasacNefilt;
	double cenaSvetlo, cenaTamno, cenaNefilt;
	double zaliheJecam, zaliheHmelj, zalihePsenica, zaliheKvasac;
	
	scanf("%lf%lf%lf%lf", &jecamSvetlo, &hmeljSvetlo, &psenicaSvetlo, &kvasacSvetlo);
	scanf("%lf%lf%lf%lf", &jecamTamno, &hmeljTamno, &psenicaTamno, &kvasacTamno);
	scanf("%lf%lf%lf%lf", &jecamNefilt, &hmeljNefilt, &psenicaNefilt, &kvasacNefilt);
	scanf("%lf%lf%lf", &cenaSvetlo, &cenaTamno, &cenaNefilt);
	scanf("%lf%lf%lf%lf", &zaliheJecam, &zaliheHmelj, &zalihePsenica, &zaliheKvasac);
	
	n = 3;
	m = 4;
	
	A = (double **)malloc((n+m+1)*sizeof(double *));
	for (i=1; i<=m+n; i++)
		A[i] = (double *)malloc((n+m+1)*sizeof(double));
		
	A[n+1][1]=jecamSvetlo; A[n+1][2]=jecamTamno; A[n+1][3]=jecamNefilt;
	A[n+2][1]=hmeljSvetlo; A[n+2][2]=hmeljTamno; A[n+2][3]=hmeljNefilt;
	A[n+3][1]=psenicaSvetlo; A[n+3][2]=psenicaTamno; A[n+3][3]=psenicaNefilt;
	A[n+4][1]=kvasacSvetlo; A[n+4][2]=kvasacTamno; A[n+4][3]=kvasacNefilt;
	
	b = (double *)malloc((n+m+1)*sizeof(double));
	c = (double *)malloc((n+m+1)*sizeof(double));
	x = (double *)malloc((n+m+1)*sizeof(double));
	NB = (int *)malloc((n+m+1)*sizeof(int));
	
	b[n+1]=zaliheJecam; b[n+2]=zaliheHmelj; b[n+3]=zalihePsenica;
	b[n+4]=zaliheKvasac;
	
	c[1]=cenaSvetlo*0.1; c[2]=cenaTamno*0.15; c[3]=cenaNefilt*0.22;
	
	for (i=1; i<=n+m; i++) {
		if (i<=n) {
			NB[i] = SKUP_N;
			b[i] = 0.0;
		}
		else {
			NB[i] = SKUP_B;
			c[i] = 0.0;
		}
	}
	
	v = 0.0;
	
}


int nadjiUlaz() {
	int e = -1;
	int i;
	for (i=1; i<=n+m; i++) {
		if (NB[i]==SKUP_N) {
			if (c[i]>0) {
				e = i;
				break;
			}
		}
	}
	
	return e;
}

int nadjiIzlaz(int e) {
	int l = -1; 
	double min = -1;
	int i;
	
	for (i=1; i<=n+m; i++) {
		if (NB[i]==SKUP_B && A[i][e]>0) {
			if (min==-1 || (b[i]/A[i][e] < min)) {
				min = b[i]/A[i][e];
				l = i;
			}
		}
	}
	
	return l;
}

void pivot(int e, int l) {
	int i,j;
	b[e] = b[l]/A[l][e];
	A[e][l] = 1/A[l][e];
	
	for (j=1; j<=n+m; j++){
		if (NB[j]==SKUP_N && j!=e) {
			A[e][j] = A[l][j]/A[l][e];
		}
	}
	
	for (i=1; i<=n+m; i++) {
		if (NB[i]==SKUP_B && i!=l) {
			b[i] = b[i]-A[i][e]*b[e];
			
			for (j=1; j<=n+m; j++) {
				if (NB[j]==SKUP_N && j!=e) {
					A[i][j] = A[i][j]-A[i][e]*A[e][j];
				}
			}
			
			A[i][l] = -A[i][e]/A[l][e];
		}
	}
	
	for (j=1; j<=n+m; j++) {
		if (NB[j]==SKUP_N && j!=e) {
			c[j] = c[j] - c[e]*A[e][j];
		}
	}
	
	c[l] = -c[e]*A[e][l];
	
	v = v + c[e]*b[e];
	
	NB[e] = SKUP_B; NB[l] = SKUP_N;

}

int main() {
	int e, l, i, j;
	unesiPodatke();
	
	while ((e=nadjiUlaz()) != -1) {
		l = nadjiIzlaz(e);
        //printf("%d %d\n", e, l);
		if (l==-1) {
			printf("Neogranicen problem.\n");
			break;
		}
		else {
			pivot(e, l);
		}
	}
	
	if (e==-1) {
		printf("%.3lf\n", v);
		
		for (i=1; i<=n; i++) {
			if (NB[i]==SKUP_B) {
				x[i] = b[i];
			}
			else {
				x[i] = 0;
			}
			printf("%.3lf ", x[i]);
		}
		printf("\n");
		
		
	}
	
	return 0;
}





